


export class ContractTypeEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/contracts/types/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteContractType" class="fa fa-trash"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveContractType" class="fa fa-save"></a>
			</div>
			<h1>{{!ctype.contractTypeId?'Nieuw type':'Bewerk type'}}</h1>
		</div>
		
		
		<form id="frmContractType" action="{{appUrl('/service/contracts/type.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="contractTypeId" value="{{ctype.contractTypeId}}" />
			
			<ez-text name="name" label="Naam" [value]="ctype.name"></ez-text>
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="ctype.edited"></ez-datetime-text>
			
			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="ctype.created"></ez-datetime-text>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	ctype = {
		name: ''
	};
	
	isNew = false;
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		if (id) {
			this.loadContractType( id );
		}
		else {
			this.isNew = true;
			this.render();
		}
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('ctype', this.ctype);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		focusFirstField( '#frmContractType' );
		
		
		$(this.container).find('input[name=name]').on('change', function() {
			this.value = trim(this.value);
		});
	}
	
	
	saveContractType() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmContractType').then(async function(e) {
			
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmContractType', json );
				
			}
			else {
				// report succesfully saved
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				// reload data?
				replaceRoute( '/masterdata/contracts/types/edit/?id=' + json.contractType.contractTypeId );
				return;
			}
			
			this.loading = false;
		}.bind(this));
	}
	
	deleteContractType() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je dit contract type wilt verwijderen?', function() {
			
			postUrl( '/service/contracts/type.do', {
				a: 'delete',
				contractTypeId: this.ctype.contractTypeId
			}).then( async function(e) {
				let json = await e.json();
				
				if (json.error) {
					showAlert('Error', 'Error: ' + e.message);
					return;
				}
				
				gotoRoute( '/masterdata/contracts/types/' );
			});
		}.bind(this));
	}
	
	
	
	loadContractType(contractTypeId) {
		postUrl( '/service/contracts/type.do', {
			a: 'view',
			id: contractTypeId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.ctype = json.contractType;
			this.render();
			
			this.loading = false;
		}.bind(this) );
	}
	
}


